/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wafflestomper.ghostwriter.datastructures.PageDetails;
import wafflestomper.ghostwriter.datastructures.Pages;
import wafflestomper.ghostwriter.utilities.BookUtilities;
import wafflestomper.ghostwriter.utilities.Clipboard;
import wafflestomper.ghostwriter.utilities.Printer;

public class FileHandler {
    public static final String GHB_PAGE_BREAK = ">>>>";
    public static final String GHB_FILE_EXTENSION = ".ghb";
    private static final int BOOK_TITLE_MAX_LEN = 32;
    private static final Printer PRINTER = new Printer();
    private static final Logger LOG = LogManager.getLogger();
    private final File bookSavePath;
    private final File signaturePath;
    private final Clipboard clipboard;
    private final List<File> lastListing = new ArrayList<File>();
    public File currentPath;
    public File lastLoadedBook;
    private String lastCheckedPath = "";

    public FileHandler(Clipboard _clipboard) {
        this.clipboard = _clipboard;
        String path = Minecraft.m_91087_().f_91069_.getAbsolutePath();
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 2);
        }
        boolean dirSuccess = true;
        File defaultPath = new File(path, "mods" + File.separator + "Ghostwriter");
        if (!defaultPath.exists() && !defaultPath.mkdirs()) {
            dirSuccess = false;
        }
        this.bookSavePath = new File(defaultPath, "SavedBooks");
        if (!this.bookSavePath.exists() && !this.bookSavePath.mkdirs()) {
            dirSuccess = false;
        }
        this.signaturePath = new File(defaultPath, "Signatures");
        if (!this.signaturePath.exists() && this.signaturePath.mkdirs()) {
            dirSuccess = false;
        }
        this.currentPath = this.bookSavePath;
        if (!dirSuccess) {
            PRINTER.gamePrint(Printer.RED + "Couldn't create one or more directories. Things will probably break");
        }
    }

    public static String cleanGHBString(String strIn) {
        strIn = strIn.replaceAll("(?s)[\\t\\r\\n ]*//.*?((\\n)|(\\r\\n)|(\\Z))", "\n");
        strIn = strIn.replaceAll("(?s)((/\\*).*?((\\*/)|(\\Z)))|(((/\\*)|(\\A)).*?(\\*/))", "");
        strIn = strIn.replaceAll("[\\t\\r\\n ]+(##|>>>>)", "$1");
        strIn = strIn.replaceAll("[\\r\\n]", "");
        return strIn;
    }

    public File getSignaturePath() {
        return this.signaturePath;
    }

    public File getSavePath() {
        return this.bookSavePath;
    }

    public List<File> listFiles(File path, boolean forceRefresh) {
        if (!path.getAbsolutePath().equals(this.lastCheckedPath) || forceRefresh) {
            this.lastCheckedPath = path.getAbsolutePath();
            this.lastListing.clear();
            Object[] newList = path.listFiles();
            if (newList == null) {
                return this.lastListing;
            }
            Arrays.sort(newList);
            ArrayList<Object> files = new ArrayList<Object>();
            for (Object f : newList) {
                if (((File)f).isDirectory()) {
                    this.lastListing.add((File)f);
                    continue;
                }
                files.add(f);
            }
            this.lastListing.addAll(files);
        }
        return this.lastListing;
    }

    public void navigateUp() {
        if (this.currentPath.getParentFile() == null) {
            return;
        }
        for (File root : File.listRoots()) {
            if (!this.currentPath.equals(root)) continue;
            return;
        }
        this.currentPath = this.currentPath.getParentFile();
    }

    public List<File> getValidRoots() {
        ArrayList<File> outList = new ArrayList<File>();
        for (File root : File.listRoots()) {
            if (root.listFiles() == null) continue;
            outList.add(root);
        }
        return outList;
    }

    public List<String> readFile(File path) {
        return this.readFile(path, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readFile(File path, String encoding) {
        BufferedReader br;
        ArrayList<String> out = new ArrayList<String>();
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), decoder));
        }
        catch (FileNotFoundException e) {
            PRINTER.gamePrint(Printer.RED + "File not found! " + path.getAbsolutePath());
            return null;
        }
        try {
            String line = br.readLine();
            while (line != null) {
                out.add(line);
                line = br.readLine();
            }
        }
        catch (CharacterCodingException e) {
            if (encoding.equals("UTF-8")) {
                PRINTER.gamePrint(Printer.DARK_GRAY + path.getAbsolutePath() + " doesn't seem to be UTF-8 encoded...");
                try {
                    br.close();
                }
                catch (IOException exc) {
                    e.printStackTrace();
                }
                List<String> list = this.readFile(path, "ISO-8859-15");
                return list;
            }
            PRINTER.gamePrint(Printer.RED + "Couldn't find a suitable decoder for " + path.getAbsolutePath());
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            PRINTER.gamePrint(Printer.RED + "Error reading file! " + path.getAbsolutePath());
            List<String> list = null;
            return list;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    private boolean loadBookwormBook(File filePath) {
        List<String> f = this.readFile(filePath);
        if (f.size() >= 4 && StringUtils.isNumeric((CharSequence)f.get(0))) {
            String[] largePages;
            this.clipboard.clearBook();
            this.clipboard.title = f.get(1);
            if (this.clipboard.title.length() > 32) {
                this.clipboard.title = this.clipboard.title.substring(0, 30) + "..";
            }
            this.clipboard.author = f.get(2);
            String bookText = f.get(f.size() - 1);
            for (String largePage : largePages = bookText.split("(\\s::){2,}")) {
                largePage = largePage.replaceAll("\\s*::\\s*", "\n  ");
                Pages pages = BookUtilities.splitIntoPages(largePage, 14);
                this.clipboard.pages.addAll(pages.asStrings());
            }
            this.clipboard.bookInClipboard = true;
            this.lastLoadedBook = filePath;
            return true;
        }
        return false;
    }

    public boolean writeFile(List<String> toWrite, File filePath) {
        boolean failedFlag = false;
        File path = filePath.getParentFile();
        if (!path.exists() && !path.mkdirs()) {
            failedFlag = true;
        }
        if (!failedFlag) {
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8));){
                for (String s : toWrite) {
                    out.write(s + "\n");
                }
            }
            catch (IOException e) {
                LOG.error("Ghostwriter: Write failed!");
                LOG.error(e.getMessage());
                return false;
            }
        }
        if (failedFlag) {
            PRINTER.gamePrint(Printer.RED + "WRITING TO DISK FAILED!");
            return false;
        }
        return true;
    }

    public boolean loadBook(File filePath) {
        if (filePath.getName().endsWith(".txt")) {
            LOG.info("Trying to load .txt as bookworm book...");
            if (this.loadBookwormBook(filePath)) {
                return true;
            }
            LOG.info("Trying to load .txt as regular text file...");
            if (this.loadPlainText(filePath)) {
                return true;
            }
        }
        if (filePath.getName().endsWith(GHB_FILE_EXTENSION)) {
            LOG.info("Loading GHB book..." + filePath);
            return this.loadBookFromGHBFile(filePath);
        }
        return false;
    }

    public boolean loadPlainText(File filePath) {
        Clipboard book = new Clipboard();
        List<String> rawFile = this.readFile(filePath);
        if (rawFile == null || rawFile.isEmpty()) {
            return false;
        }
        StringBuilder concatFile = new StringBuilder();
        for (String line : rawFile) {
            concatFile.append(line).append("\n");
        }
        String pageBreak = ">>>><<<<>>>><<<<";
        Pages splitPages = BookUtilities.splitIntoPages(concatFile.toString(), 14, pageBreak);
        book.pages.addAll(splitPages.asStrings());
        book.bookInClipboard = true;
        this.clipboard.clone(book);
        this.lastLoadedBook = filePath;
        return true;
    }

    public boolean loadBookFromGHBFile(File filePath) {
        Clipboard book = new Clipboard();
        List<String> rawFile = this.readFile(filePath);
        if (rawFile == null || rawFile.isEmpty()) {
            return false;
        }
        StringBuilder concatFile = new StringBuilder();
        for (String line : rawFile) {
            if (line.toLowerCase().startsWith("title:") && book.title.isEmpty()) {
                if (line.length() < 7) continue;
                book.title = FileHandler.cleanGHBString(line.substring(6)).trim();
                if (!line.contains("/*")) continue;
                concatFile.append(line.substring(line.indexOf("/*"))).append("\\n");
                continue;
            }
            if (line.toLowerCase().startsWith("author:") && book.author.isEmpty()) {
                if (line.length() < 8) continue;
                book.author = FileHandler.cleanGHBString(line.substring(7)).trim();
                if (!line.contains("/*")) continue;
                concatFile.append(line.substring(line.indexOf("/*"))).append("\\n");
                continue;
            }
            concatFile.append(line).append("\n");
        }
        String concatFileStr = FileHandler.cleanGHBString(concatFile.toString());
        concatFileStr = BookUtilities.removeRedundantFormatChars(concatFileStr, GHB_PAGE_BREAK);
        concatFileStr = concatFileStr.replaceAll("##", "\\\n");
        Pages splitPages = BookUtilities.splitIntoPages(concatFileStr, 14, GHB_PAGE_BREAK);
        book.pages.addAll(splitPages.asStrings());
        book.bookInClipboard = true;
        this.clipboard.clone(book);
        this.lastLoadedBook = filePath;
        return true;
    }

    public void saveBookToGHBFile(String title, String author, List<String> pages, File savePath) {
        PRINTER.gamePrint(Printer.GRAY + "Saving book to file...");
        ArrayList<String> toWrite = new ArrayList<String>();
        toWrite.add("//Book saved in GHB format at " + this.getUTC());
        if (!title.isEmpty()) {
            toWrite.add("title:" + title);
        }
        if (!author.isEmpty()) {
            toWrite.add("author:" + author);
        }
        toWrite.add("//=======================================");
        for (int i = 0; i < pages.size(); ++i) {
            String pageAsString = pages.get(i);
            while (pageAsString.startsWith("\"") && pageAsString.endsWith("\"")) {
                pageAsString = pageAsString.substring(1, pageAsString.length() - 1);
            }
            pageAsString = pageAsString.replaceAll("\\\\n", "\\\n");
            PageDetails currPage = BookUtilities.splitIntoPages(pageAsString, 0).get(0);
            for (String line : currPage.lines) {
                toWrite.add(line.replaceAll("\\n", "##"));
            }
            if (i >= pages.size() - 1) continue;
            toWrite.add(">>>>  // Page " + (i + 2));
        }
        if (this.writeFile(toWrite, savePath)) {
            PRINTER.gamePrint(Printer.GREEN + "Book saved to: " + savePath);
        } else {
            PRINTER.gamePrint(Printer.RED + "WRITING BOOK TO DISK FAILED!");
        }
    }

    public String getUTC() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }
}

